-- Copyright (c) 2019 Darren Watts
-- If anything here is useful to other people, feel free to include it in other scripts.

Triggers = {}
Messages = {}
IsTalking = false
BombCodeStart = 658

function Triggers.idle()
  if not IsTalking and get_stashed("talking") then -- Just activated
    local messages = get_greeting()
    Messages = messages
    IsTalking = true
  elseif not get_stashed("talking") then
    IsTalking = false
  end

  if IsTalking then
    for i = 1, #Messages do
      Players.print(Messages[i])
    end

    for i = 1, 7 - #Messages do
      Players.print("")
    end
    BombCodeStart = get_stashed_num("bomb_code")
  end
end

function talk(str)
  if get_stashed("talking") then
    if not Players[0].weapons.active then
      local messages = get_response(str)
      Messages = messages
    end
  end
end

function get_sector(coord)
  return math.floor(coord) + 16
end

function get_greeting()
  local row = get_sector(Players[0].y)
  local col = get_sector(Players[0].x)
  local body = get_body(row, col)

  return body:get_greeting()
end

function get_response(str)
  local row = get_sector(Players[0].y)
  local col = get_sector(Players[0].x)
  local body = get_body(row, col)

  if str == "bye" then
    stash("talking", nil)
    return {}
  else
    return body:get_response(str)
  end
end

function turbo()
  local p = Players[0]
  if p.items["alien weapon ammo"] == 0 then
    p.items["alien weapon ammo"] = 1
  else
    p.items["alien weapon ammo"] = 0
  end
end

function cheat()
  Players[0].items["alien weapon ammo"] = Players[0].items["alien weapon ammo"] + 1000
end

function save()
  Game.save()
end

function arm(code, detonation_time)
  if not tonumber(code) then
    code = 0
  end
  if not tonumber(detonation_time) then
    detonation_time = 0
  end
  Annotations.new(Polygons[0], "arm_" .. code .. "_" .. detonation_time)
end

function get_body(row, col)
  local row = get_sector(Players[0].y)
  local col = get_sector(Players[0].x)
  local body = nil
  if Level.index == 0 and row == 6 and col == 14 then
    body = AnonymousLevel0
  elseif Level.index == 2 and row == 1 and col == 3 then
    body = GuntherLevel2
  elseif Level.index == 2 and row == 26 and col == 26 then
    body = AnonymousLevel2
  elseif Level.index == 3 and row == 4 and col == 16 then
    body = AnonymousLevel3
  elseif Level.index == 3 and row == 19 and col == 13 then
    body = HansLevel3
  elseif Level.index == 4 and row == 2 and col == 27 then
    body = AnonymousLevel4
  elseif Level.index == 5 and row == 13 and col == 1 then
    body = ClaudeLevel5
  elseif Level.index == 6 and row == 4 and col == 5 then
    body = JoachimLevel6
  elseif Level.index == 7 and row == 11 and col == 18 then
    body = BehrensLevel7
  elseif Level.index == 8 and row == 26 and col == 19 then
    body = AnonymousLevel8
  elseif Level.index == 9 and row == 17 and col == 9 then
    body = AnonymousLevel9
  elseif Level.index == 10 and row == 14 and col == 14 then
    body = WalterLevel10
  elseif Level.index == 11 and row == 7 and col == 16 then
    body = JohnLevel11
  elseif Level.index == 12 and row == 25 and col == 22 then
    body = AnonymousLevel12
  elseif Level.index == 14 and row == 18 and col == 14 then
    body = AnonymousLevel14_1
  elseif Level.index == 14 and row == 3 and col == 12 then
    body = AnonymousLevel14_2
  elseif Level.index == 14 and row == 2 and col == 14 then
    body = FriedrichLevel14
  elseif Level.index == 14 and row == 1 and col == 16 then
    body = MullerLevel14
  elseif Level.index == 14 and row == 3 and col == 18 then
    body = ThomasLevel14
  elseif Level.index == 15 and row == 20 and col == 22 then
    body = EdLevel15
  elseif Level.index == 15 and row == 23 and col == 2 then
    body = StevenLevel15
  elseif Level.index == 15 and row == 24 and col == 5 then
    body = JasonLevel15
  elseif Level.index == 15 and row == 25 and col == 8 then
    body = DarrenLevel15
  elseif Level.index == 15 and row == 29 and col == 7 then
    body = SeanLevel15
  elseif Level.index == 17 and row == 2 and col == 29 then
    body = GregLevel17
  elseif Level.index == 18 and row == 3 and col == 30 then
    body = PedroLevel18
  elseif Level.index == 19 and row == 8 and col == 29 then
    body = JuanLevel19
  elseif Level.index == 23 and row == 29 and col == 2 then
    body = JavierLevel23
  end
  return body
end

function stash(key, val)
  Level.stash["__AOPID__" .. key] = val
end

function get_stashed_num(key)
  local val = get_stashed(key)
  return tonumber(val)
end

function get_stashed(key)
  return Level.stash["__AOPID__" .. key]
end

-- Dead bodies

AnonymousLevel0 = {}

function AnonymousLevel0:get_greeting()
  local messages = {}

  if not self.visited then
    table.insert(messages, "WHAT'S HAPPENING?  Who are you?- WHAT")
    table.insert(messages, "ARE YOU?  Am I dead?  Where am I?")

    self.visited = true
  else
    table.insert(messages, "Who are you?  Am I dead?  I remember now ...")
  end

  return messages
end

function AnonymousLevel0:get_response(str)
  local messages = {}

  if str == "name" then
    table.insert(messages, "I ... I don't remember my name.  I can see my")
    table.insert(messages, "face in a mirror- shaving in the jungle this")
    table.insert(messages, "morning, before we broke camp")
    table.insert(messages, "and came here- but I don't remember my name.")
  elseif str == "death" or str == "die" or str == "dead" or str == "shot" then
    table.insert(messages, "Muller shot me in the back because I")
    table.insert(messages, "wouldn't follow him through this door- but")
    table.insert(messages, "he didn't come back.  He got what he")
    table.insert(messages, "deserved...")
  elseif str == "mission" then
    table.insert(messages, "Muller never told us what our mission here")
    table.insert(messages, "was- just that we would be in the jungle")
    table.insert(messages, "for a few months.  This jungle is a humid,")
    table.insert(messages, "sticky hell.  I remember Cologne...")
  elseif str == "rune" then
    table.insert(messages, "That strange drawing on the floor, where the")
    table.insert(messages, "four corridors meet.")
  elseif str == "before" or str == "remember" then
    table.insert(messages, "Yes, this has happened before.  This same")
    table.insert(messages, "weird, speechless, disembodied sort of")
    table.insert(messages, "conversation.  I don't remember more,")
    table.insert(messages, "sorry...")
  elseif str == "muller" or str == "bastard" or str == "captain" then
    table.insert(messages, "Muller was our captain.  An ugly, short little")
    table.insert(messages, "man.  Totally devoted to our country.  A real")
    table.insert(messages, "bastard.  He shot me twice in the back.")
  elseif str == "friends" then
    table.insert(messages, "All my friends are dead now.  Seven above,")
    table.insert(messages, "the rest below.  Muller killed them all...")
  elseif str == "jungle" then
    table.insert(messages, "Let's not talk about the jungle...")
  elseif str == "door" or str == "doors" or str == "follow" then
    table.insert(messages, "Muller had some strange musical instrument")
    table.insert(messages, "he brought from Germany.  When he played it")
    table.insert(messages, "on that rune in the middle of the floor, those")
    table.insert(messages, "two locked doors opened.")
  elseif str == "camp" then
    table.insert(messages, "We camped a few miles away.  That was my")
    table.insert(messages, "last night outside.")
  elseif str == "pipes" or str == "musical" or str == "instrument" then
    table.insert(messages, "I didn't see it for long, but it was bizarre")
    table.insert(messages, "brass device covered with a green cloth.")
  elseif str == "cologne" or str == "home" then
    table.insert(messages, "Cologne ... God, I'll never see it again.  Are")
    table.insert(messages, "you sure I'm dead?  How can you KNOW?")
    table.insert(messages, "How could I be talking to you, if I were")
    table.insert(messages, "dead?")
  elseif str == "country" or str == "germany" then
    table.insert(messages, "We were all from Germany.")
  else
    if Game.random(2) < 1 then
      table.insert(messages, "I don't understand, what do you mean?")
    else
      table.insert(messages, "Are you trying to confuse me?  What are you")
      table.insert(messages, "saying?")
    end
  end

  return messages
end

AnonymousLevel2 = {}

function AnonymousLevel2:get_greeting()
  local messages = {}
  table.insert(messages, "I'm cold, so cold ...")

  return messages
end

function AnonymousLevel2:get_response(str)
  local messages = {}

  if str == "name" then
    table.insert(messages, "I don't remember.  I'm so cold ...")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "Death is so cold and lonely.  I can't recall ...")
    table.insert(messages, "anything ...")
  else
    table.insert(messages, "I don't remember.  I'm so cold ...")
  end

  return messages
end

GuntherLevel2 = {}

function GuntherLevel2:get_greeting()
  local messages = {}
  table.insert(messages, "You handle that P4 well, for a foreigner.")

  return messages
end

function GuntherLevel2:get_response(str)
  local messages = {}

  if str == "name" or str == "gunther" then
    table.insert(messages, "My name is Gunther, I think.  It's so hard to")
    table.insert(messages, "remember things, with so much time alone")
    table.insert(messages, "to think ...")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "I was leading a group of four men and we")
    table.insert(messages, "stumbled on five of those long-tongued")
    table.insert(messages, "monsters.  Hans and Behrens ran, and I died")
    table.insert(messages, "trying to give Joachim time to escape- he")
    table.insert(messages, "was wounded.")
  elseif
    str == "walther" or str == "p4" or str == "pistol" or str == "hans" or str == "ammunition" or str == "magazines" or
      str == "bullets" or
      str == "magazine" or
      str == "bullet"
   then
    table.insert(messages, "Hans was in charge of carrying most of our")
    table.insert(messages, "ammunition, because he couldn't shoot")
    table.insert(messages, "straight.  He wasn't with the group when")
    table.insert(messages, "they came back, so if you can find him ask")
    table.insert(messages, "him what he did with all of it.")
  elseif str == "muller" then
    table.insert(messages, "Nobody liked Muller.  I was no exception.  He")
    table.insert(messages, "didn't even tell us why we were here.  I")
    table.insert(messages, "hardly even know where I am.")
  elseif str == "headless" or str == "tongue" or str == "monster" or str == "monsters" then
    table.insert(messages, "Those headless things disgust me.  There")
    table.insert(messages, "were so many of them after a while that we")
    table.insert(messages, "started killing them with our knives, to")
    table.insert(messages, "conserve ammunition.  The zombies were a")
    table.insert(messages, "different story ...")
  elseif str == "behrens" then
    table.insert(messages, "I don't remember Behrens very well, he")
    table.insert(messages, "mostly kept to himself.")
  elseif str == "joachim" then
    table.insert(messages, "Joachim and I were good friends, I hope he")
    table.insert(messages, "made it out.")
  elseif str == "alone" or str == "think" or str == "conscious" or str == "senses" then
    table.insert(messages, "It's horrible, being conscious but deprived of")
    table.insert(messages, "nearly all your senses like this.  I wonder")
    table.insert(messages, "how long it will last ...")
  elseif str == "foreigner" or str == "germany" or str == "europe" then
    table.insert(messages, "It's obvious from the way you talk")
    table.insert(messages, "that you're not from Germany, or even Europe.")
    table.insert(messages, "You must be from the States.")
  elseif str == "talk" or str == "states" or str == "america" or str == "accent" or str == "yankee" then
    table.insert(messages, "You have a Yankee accent.")
  elseif str == "zombies" or str == "zombie" or str == "dissolve" then
    table.insert(messages, "The only way to stop those zombies is to")
    table.insert(messages, "shoot them until they dissolve.")
  else
    local rand = Game.random(3)
    if rand == 0 then
      table.insert(messages, "I don't understand, what do you mean?")
    elseif rand == 1 then
      table.insert(messages, "I don't follow you.")
    else
      table.insert(messages, "Say that again?")
    end
  end

  return messages
end

AnonymousLevel3 = {}

function AnonymousLevel3:get_greeting()
  local messages = {}
  if not self.visited then
    table.insert(messages, "What are you?  What's happening?")
    self.visited = true
  else
    table.insert(messages, "Why are you back?  Go away.  Don't disturb")
    table.insert(messages, "me.")
  end

  return messages
end

function AnonymousLevel3:get_response(str)
  local messages = {}

  if str == "name" then
    table.insert(messages, "I don't remember my name.  I don't")
    table.insert(messages, "remember my family.  All I remember is this")
    table.insert(messages, "dusty room and those people who have")
    table.insert(messages, "passed through it since I died.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "Isn't it obvious?  Or didn't you notice that")
    table.insert(messages, "both my legs are missing?  I can still see")
    table.insert(messages, "that headless thing chewing and clawing at")
    table.insert(messages, "me ...")
  elseif str == "muller" then
    table.insert(messages, "Muller was the leader of our expedition, how")
    table.insert(messages, "did you know him?  Never mind.  I don't care.")
  elseif str == "headless" or str == "tongue" or str == "monster" or str == "monsters" then
    table.insert(messages, "I hate them, I HATE THEM.  Don't talk about")
    table.insert(messages, "them.  Go away, please go away.")
  elseif str == "hans" then
    table.insert(messages, "Hans ran through here, alone, a few hours")
    table.insert(messages, "after I died.  He ran right into two of those")
    table.insert(messages, "zombies and fled in the direction he came.")
    table.insert(messages, "He looked badly hurt.")
  elseif str == "behrens" or str == "joachim" or str == "claude" then
    table.insert(messages, "I didn't know him very well.")
  elseif str == "room" or str == "dusty" or str == "those" or str == "who" or str == "people" then
    table.insert(messages, "A group of people passed through here years")
    table.insert(messages, "ago and one of their group walked through")
    table.insert(messages, "the opposite wall of this room.  I don't know")
    table.insert(messages, "how he did it.")
  elseif str == "zombies" or str == "zombie" then
    table.insert(messages, "We all hated those zombies.  The only way to")
    table.insert(messages, "stop them from attacking was to shoot them")
    table.insert(messages, "until they dissolved.")
  elseif str == "group" or str == "he" or str == "spanish" or str == "speak" then
    table.insert(messages, "They were speaking Spanish.  I couldn't tell")
    table.insert(messages, "where they were from, specifically.")
  elseif str == "wall" then
    table.insert(messages, "I'd point to it, if I could, but I'm sort of")
    table.insert(messages, "dead, sorry.  It's opposite the entrance you")
    table.insert(messages, "came in, if you want to try.")
  elseif str == "family" then
    table.insert(messages, "I don't remember them, I told you, I DON'T")
    table.insert(messages, "REMEMBER THEM.")
  else
    local rand = Game.random(3)
    if rand == 0 then
      table.insert(messages, "What are you saying?  I can't understand you.")
    elseif rand == 1 then
      table.insert(messages, "What?")
    else
      table.insert(messages, "You're confusing me.  I don't understand.")
    end
  end

  return messages
end

HansLevel3 = {}

function HansLevel3:get_greeting()
  local messages = {}
  if not self.visited then
    table.insert(messages, "We just couldn't kill them; our bullets went")
    table.insert(messages, "right through those phantasms!  Watch out,")
    table.insert(messages, "they're everywhere.")
    self.visited = true
  else
    table.insert(messages, "Why are you back?  Leave!  Get out before")
    table.insert(messages, "they come back ...")
  end
  return messages
end

function HansLevel3:get_response(str)
  local messages = {}

  if str == "name" or str == "hans" then
    table.insert(messages, "My name is Hans ... I think I remember being")
    table.insert(messages, "called Hans.")
  elseif str == "death" or str == "die" or str == "dead" or str == "nothing" then
    table.insert(messages, "One of those shadowy things enveloped and")
    table.insert(messages, "killed me.  Nothing seemed to hurt it-")
    table.insert(messages, "bullets, knives, grenades.  I ran as far as I")
    table.insert(messages, "could, wounded, but I finally died here.")
  elseif
    str == "walther" or str == "p4" or str == "pistol" or str == "magazine" or str == "bullets" or str == "clip" or
      str == "ammunition" or
      str == "ammo" or
      str == "bones" or
      str == "skull" or
      str == "ladder" or
      str == "bullet" or
      str == "magazines"
   then
    table.insert(messages, "I jumped down the ladder from the level")
    table.insert(messages, "above and ran all the way here.  Somewhere")
    table.insert(messages, "on the way I hid most of my spare clips in a")
    table.insert(messages, "room full of bones, stuffed in a skull.")
    table.insert(messages, "Search there if you need them.")
  elseif
    str == "phantasms" or str == "phantasm" or str == "shadowy" or str == "things" or str == "specters" or
      str == "banshees" or
      str == "they"
   then
    table.insert(messages, "Muller called them shades.  There's this")
    table.insert(messages, "horrible, chilling moment when they scream")
    table.insert(messages, "and your vision flickers and you wonder if")
    table.insert(messages, "you're going to die.  We never found a way to")
    table.insert(messages, "kill them.")
  elseif str == "shades" then
    table.insert(messages, "He called them shades because you can see")
    table.insert(messages, "through them, like they're just shadows.")
    table.insert(messages, "They have two, glowing red eyes.  Run as")
    table.insert(messages, "fast as you can, if you see one.")
  elseif str == "scream" then
    table.insert(messages, "Their screams are awful, don't make me")
    table.insert(messages, "think about it.")
  elseif str == "muller" then
    table.insert(messages, "Muller, damn him.  This is all his fault.  I'm")
    table.insert(messages, "sure he's dead, somewhere ...")
  elseif str == "behrens" or str == "joachim" or str == "claude" then
    table.insert(messages, "I didn't know him very well, sorry.  I was a")
    table.insert(messages, "new recruit.")
  elseif str == "grenades" or str == "grenade" then
    table.insert(messages, "The grenades worked great on the headless")
    table.insert(messages, "creatures, but we only had about thirty of")
    table.insert(messages, "them and we used them too fast.")
  elseif
    str == "knives" or str == "knife" or str == "blade" or str == "machete" or str == "headless" or str == "creature"
   then
    table.insert(messages, "Our machetes worked great on the headless")
    table.insert(messages, "creatures, and we saved bullets by killing")
    table.insert(messages, "them that way, but blades didn't hurt the")
    table.insert(messages, "specters.")
  elseif str == "recruit" then
    table.insert(messages, "Of all the first missions I could have been")
    table.insert(messages, "sent on, I had to come to this place.")
  elseif str == "mission" or str == "place" or str == "here" then
    table.insert(messages, "Muller never told us why we were here.  I")
    table.insert(messages, "died for nothing, I'm sure.")
  elseif str == "leave" then
    table.insert(messages, "Yes, leave!")
  else
    local rand = Game.random(2)
    if rand == 0 then
      table.insert(messages, "I don't understand.  Please leave, please.")
    else
      table.insert(messages, "You don't make any sense.  Leave, please.")
    end
  end

  return messages
end

AnonymousLevel4 = {}

function AnonymousLevel4:get_greeting()
  local messages = {}
  table.insert(messages, "Watch out for the specters, they're")
  table.insert(messages, "everywhere.")

  return messages
end

function AnonymousLevel4:get_response(str)
  local messages = {}

  if str == "name" then
    table.insert(messages, "I don't have a name.  Not anymore.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "I was running from a specter when I met")
    table.insert(messages, "three of those ghastly zombie creatures.")
    table.insert(messages, "They surrounded me and clubbed me with")
    table.insert(messages, "their bones.")
  elseif
    str == "specters" or str == "banshees" or str == "wraiths" or str == "monsters" or str == "phantasms" or
      str == "phantasm"
   then
    table.insert(messages, "I hate those translucent things.  Run from")
    table.insert(messages, "them, it's all you can do.")
  elseif str == "zombie" or str == "zombies" then
    table.insert(messages, "I much preferred the headless things, which")
    table.insert(messages, "stopped spitting at you when you shot them.")
    table.insert(messages, "The only way to stop a zombie is to kill it.")
  elseif str == "bones" or str == "dodge" or str == "trapped" then
    table.insert(messages, "It was really easy to dodge the zombie")
    table.insert(messages, "bones, if you had space to move around.  I")
    table.insert(messages, "was trapped.")
  elseif str == "spit" or str == "headless" then
    table.insert(messages, "We were all covered with their green goo by")
    table.insert(messages, "the time we got this far.  It smelled")
    table.insert(messages, "revolting.")
  elseif str == "anymore" or str == "now" then
    table.insert(messages, "Names don't matter now.")
  else
    table.insert(messages, "Watch out for the specters, they're")
    table.insert(messages, "everywhere.")
  end

  return messages
end

ClaudeLevel5 = {}

function ClaudeLevel5:get_greeting()
  local messages = {}
  table.insert(messages, "Don't take my gun, please.  Go away.  They're")
  table.insert(messages, "following you.  Don't you see them?")

  return messages
end

function ClaudeLevel5:get_response(str)
  local messages = {}

  if str == "name" or str == "claude" then
    table.insert(messages, "Claude is dead now.  He wants you to leave.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "A specter got so close to me I could hardly")
    table.insert(messages, "see.  It was cold and dark, just like now.  I")
    table.insert(messages, "was already wounded ...")
  elseif
    str == "they" or str == "banshee" or str == "specter" or str == "wraith" or str == "phantasm" or str == "monster" or
      str == "phantasms" or
      str == "monsters"
   then
    table.insert(messages, "The specters!  Please leave, before they find")
    table.insert(messages, "me.")
  elseif str == "gun" or str == "pistol" then
    table.insert(messages, "Don't take it, please!  I'll need it if they")
    table.insert(messages, "come back.  They haven't seen me yet.")
  elseif str == "wounded" or str == "hurt" or str == "headless" or str == "creature" or str == "ambush" then
    table.insert(messages, "I got hurt badly a few minutes before the")
    table.insert(messages, "specter got me.  We were ambushed by")
    table.insert(messages, "headless creatures, and three of them")
    table.insert(messages, "surrounded me ...")
  elseif str == "cold" or str == "dark" or str == "horrible" or str == "now" then
    table.insert(messages, "Don't make me think about it.  It's one of the")
    table.insert(messages, "few things I do remember, and it was")
    table.insert(messages, "horrible.")
  elseif str == "pyramid" or str == "here" or str == "place" or str == "outside" or str == "day" then
    table.insert(messages, "I remember seeing the pyramid from")
    table.insert(messages, "outside, during the day, and thinking that it")
    table.insert(messages, "looked empty and abandoned.")
  elseif str == "hans" or str == "joachim" or str == "behrens" or str == "gunther" then
    table.insert(messages, "I hardly remember him ...")
  elseif str == "muller" then
    table.insert(messages, "Muller!  I've been trying to recall his name")
    table.insert(messages, "for years.  He's the one that brought us to")
    table.insert(messages, "this place.  I hope he died here.  None of us")
    table.insert(messages, "liked him.")
  elseif str == "empty" or str == "abandoned" then
    table.insert(messages, "I couldn't have been more wrong.")
  else
    local rand = Game.random(2)
    if rand == 0 then
      table.insert(messages, "I don't understand.")
    else
      table.insert(messages, "What do you mean?")
    end
  end

  return messages
end

JoachimLevel6 = {}

function JoachimLevel6:get_greeting()
  local messages = {}
  if not self.visited then
    table.insert(messages, "What a miserable place to spend eternity.")
    table.insert(messages, "Death is far worse than you can imagine.")
    self.visited = true
  else
    table.insert(messages, "Why are you back?  Leave!  Get out before")
    table.insert(messages, "they come back ...")
  end
  return messages
end

function JoachimLevel6:get_response(str)
  local messages = {}

  if str == "name" or str == "joachim" then
    table.insert(messages, "My name is Joachim.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "I crawled into this dead end after I was")
    table.insert(messages, "wounded.  While the others were fighting a")
    table.insert(messages, "group of zombies, a headless creature found")
    table.insert(messages, "me.  After that, Muller turned back and left.")
  elseif str == "headless" then
    table.insert(messages, "They're blind, weak monsters, but I couldn't")
    table.insert(messages, "fight it off because I was hurt.")
  elseif str == "muller" or str == "retreat" then
    table.insert(messages, "Muller only brought the expedition this far,")
    table.insert(messages, "and then turned back.  It took him almost a")
    table.insert(messages, "day, with seven deaths, to realize we were")
    table.insert(messages, "going the wrong way.")
  elseif str == "hans" or str == "claude" then
    table.insert(messages, "He died on a lower level.")
  elseif str == "behrens" then
    table.insert(messages, "I think Behrens made it out when the group")
    table.insert(messages, "retreated, but I'm not sure.")
  elseif str == "expedition" or str == "group" then
    table.insert(messages, "Muller was looking for something to help")
    table.insert(messages, "Germany in the war, I don't know what it")
    table.insert(messages, "was- he never told us anything.")
  elseif str == "zombie" or str == "zombies" or str == "earthquake" or str == "blue" or str == "shake" or str == "arms" then
    table.insert(messages, "We met one zombie wearing blue, instead of")
    table.insert(messages, "the usual red, and it raised it's arms and")
    table.insert(messages, "made the ground shake like an earthquake.")
    table.insert(messages, "Muller and Friedrich killed it quickly.")
  elseif str == "eternity" or str == "worse" then
    table.insert(messages, "What a miserable place to spend eternity.")
    table.insert(messages, "Death is far worse than you can imagine.")
  elseif str == "germany" or str == "war" then
    table.insert(messages, "Sometimes I wonder if the war even started,")
    table.insert(messages, "or how it is going, or whether it's over.")
    table.insert(messages, "Most of the time I don't care.")
  elseif str == "friedrich" or str == "second" then
    table.insert(messages, "Friedrich was Muller's second.  He survived")
    table.insert(messages, "this far.")
  elseif str == "phantasms" or str == "phantasm" or str == "they" or str == "spectre" or str == "banshees" or str == "shades" then
    table.insert(messages, "Those invincible phantasms are finally what")
    table.insert(messages, "convinced Muller we should turn back, I")
    table.insert(messages, "think.  There are at least three on this level,")
    table.insert(messages, "you should turn back, too.")
  elseif str == "wounded" or str == "hurt" then
    table.insert(messages, "I let one of those phantasms get too close to")
    table.insert(messages, "me.  That was nearly the end.")
  elseif str == "grenades" or str == "grenade" then
    table.insert(messages, "If only we'd had some grenades left ...")
  elseif str == "seven" then
    table.insert(messages, "Three of them were Claude, Hans and")
    table.insert(messages, "Gunther ... I can't remember the other four,")
    table.insert(messages, "or whether Behrens made it out or not.")
  elseif str == "wrong" or str == "way" then
    table.insert(messages, "Muller was an idiot.  Even I could tell this")
    table.insert(messages, "was the wrong way.")
  else
    local rand = Game.random(2)
    if rand == 0 then
      table.insert(messages, "I don't understand.")
    else
      table.insert(messages, "Say that again?")
    end
  end

  return messages
end

BehrensLevel7 = {}

function BehrensLevel7:get_greeting()
  local messages = {}
  table.insert(messages, "You scared me, I thought you were one of")
  table.insert(messages, "those big rock-throwing monsters.  They")
  table.insert(messages, "still bother me, even now.")

  return messages
end

function BehrensLevel7:get_response(str)
  local messages = {}

  if str == "name" or str == "behrens" then
    table.insert(messages, "Behrens, I think my name is Behrens.  It's")
    table.insert(messages, "hard not to forget, over all this time.")
  elseif
    str == "death" or str == "die" or str == "dead" or str == "skull" or str == "ghoul" or str == "ghouls" or str == "monster" or
      str == "creature" or
      str == "rock" or
      str == "rock-throwing" or
      str == "throwing" or
      str == "monsters"
   then
    table.insert(messages, "My skull was crushed by one of those huge")
    table.insert(messages, "ghouls.  They're not very tough to kill, but")
    table.insert(messages, "they sure hit hard.  I saw Muller killed two")
    table.insert(messages, "with his knife.")
  elseif str == "time" or str == "forget" or str == "forgotten" or str == "self" then
    table.insert(messages, "Death isn't final and abrupt, like I expected.")
    table.insert(messages, "You're only truly dead when you've forgotten")
    table.insert(messages, "everything- when you remember nothing of")
    table.insert(messages, "your former self.")
  elseif str == "knife" or str == "muller" then
    table.insert(messages, "I saw Muller unload an entire clip from his")
    table.insert(messages, "machine pistol into a group of those")
    table.insert(messages, "monsters, and then kill the last two with")
    table.insert(messages, "his knife.")
  elseif str == "friedrich" then
    table.insert(messages, "I didn't know Friedrich very well.")
  elseif str == "machine" or str == "pistol" or str == "mp-41" then
    table.insert(messages, "Yes, the MP-41.  We had several of them.")
    table.insert(messages, "The group took mine when they left.")
  elseif str == "hans" or str == "joachim" or str == "claude" then
    table.insert(messages, "He's dead.")
  elseif str == "scare" or str == "frighten" or str == "bother" then
    table.insert(messages, "You scared me, I thought you were one of")
    table.insert(messages, "those big rock-throwing monsters.  They")
    table.insert(messages, "still bother me, even now.")
  elseif str == "group" or str == "expedition" or str == "mission" or str == "soldiers" then
    table.insert(messages, "There were eighteen of us, I think, and I")
    table.insert(messages, "doubt anyone left alive.  I never saw anyone")
    table.insert(messages, "come back this way.")
  elseif str == "forgot" or str == "forgotten" or str == "self" then
    table.insert(messages, "Death isn't final and abrupt, like I expected.")
    table.insert(messages, "You're only truly dead when you've forgotten")
    table.insert(messages, "everything- when you remember nothing of")
    table.insert(messages, "your former self.")
  elseif str == "grenades" or str == "grenade" or str == "headless" or str == "pathetic" or str == "alive" then
    table.insert(messages, "If Muller hadn't let us use all the grenades")
    table.insert(messages, "early, on those pathetic headless creatures,")
    table.insert(messages, "I might still be alive now.")
  else
    local rand = Game.random(2)
    if rand == 0 then
      table.insert(messages, "I don't understand you.")
    else
      table.insert(messages, "What?  You're not making any sense.")
    end
  end

  return messages
end

AnonymousLevel8 = {}

function AnonymousLevel8:get_greeting()
  local messages = {}
  table.insert(messages, "It was twelve days ago, it must have been.")

  return messages
end

function AnonymousLevel8:get_response(str)
  local messages = {}

  if str == "name" then
    table.insert(messages, "Names are unimportant, but I know yours.")
    table.insert(messages, "I'll never tell him, don't worry.  I know")
    table.insert(messages, "better.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "I'm not dead, I've only settled down to rest")
    table.insert(messages, "for a moment.  Go along, I'll catch up with")
    table.insert(messages, "you soon.")
  elseif str == "days" or str == "twelve" then
    table.insert(messages, "No, not twelve- hundreds.  Sixteen Sundays,")
    table.insert(messages, "even.  I've been counting.  I can tell you")
    table.insert(messages, "haven't.")
  elseif str == "him" or str == "rise" or str == "master" or str == "small" or str == "insignificant" then
    table.insert(messages, "You know.  I can't say.  He who rises with")
    table.insert(messages, "the tides, master of all things small and")
    table.insert(messages, "insignificant.")
  elseif str == "yes" or str == "no" then
    table.insert(messages, "It doesn't matter.")
  elseif str == "tides" then
    table.insert(messages, "Not the tides, fool!  Don't you understand?")
  elseif str == "grenades" then
    table.insert(messages, "Grenades ... Mmmm ... tasty.")
  else
    local rand = Game.random(2)
    if rand == 0 then
      table.insert(messages, "You're not making any sense, are you all")
      table.insert(messages, "right?")
    else
      table.insert(messages, "Leave me now, blasphemer!")
    end
  end

  return messages
end

AnonymousLevel9 = {}

function AnonymousLevel9:light_on()
  if get_stashed("flashlight_on") then
    return true
  end
  return false
end

function AnonymousLevel9:get_greeting()
  local messages = {}
  if self:light_on() then
    table.insert(messages, "Get that light away from me!  Get it away!")
    table.insert(messages, "No lights!  They're coming!")
  else
    table.insert(messages, "Are they following you?  You don't have any")
    table.insert(messages, "lights, do you?  Stay away ...")
  end

  return messages
end

function AnonymousLevel9:get_response(str)
  local messages = {}

  if self:light_on() then
    if str == "light" or str == "lights" or str == "flashlight" then
      table.insert(messages, "They're attracted to your light.  Fool!  Get")
      table.insert(messages, "away from me!")
    elseif str == "they" or str == "who" then
      table.insert(messages, "Those things, those things!  They're all")
      table.insert(messages, "around, they hide in the corners until they")
      table.insert(messages, "see light ...")
    else
      table.insert(messages, "Get that light away from me!  Get it away!")
      table.insert(messages, "No lights!  They're coming!")
    end
  else
    if str == "name" then
      table.insert(messages, "I don't remember my name.  It's been so long")
      table.insert(messages, "since I heard it.  I don't even remember my")
      table.insert(messages, "family, or my home.")
    elseif str == "death" or str == "die" or str == "dead" then
      table.insert(messages, "I was the first man down the ladder, and")
      table.insert(messages, "suddenly I was surrounded by these")
      table.insert(messages, "shrieking things.  I ran, but they followed")
      table.insert(messages, "me ...")
    elseif str == "they" or str == "who" or str == "things" or str == "rats" or str == "rat" then
      table.insert(messages, "Those things, those rats with wings, haven't")
      table.insert(messages, "you seen them?  They swarmed my torch")
      table.insert(messages, "before I could put it out ...")
    elseif str == "torch" then
      table.insert(messages, "I didn't think to put it out.  I was such a")
      table.insert(messages, "fool.")
    elseif str == "shriek" then
      table.insert(messages, "I hear them screaming now, don't you?")
    elseif str == "ladder" then
      table.insert(messages, "The same ladder you must have come down")
      table.insert(messages, "to get here.")
    elseif str == "light" or str == "lights" or str == "flashlight" then
      table.insert(messages, "They swarm to lights, biting and scratching")
      table.insert(messages, "anything in sight.")
    elseif str == "family" or str == "parents" then
      table.insert(messages, "I think my mother was dead.  My father was")
      table.insert(messages, "in the party.")
    elseif str == "party" or str == "nazi" then
      table.insert(messages, "The Nazis.  My father was so proud I was")
      table.insert(messages, "selected to go on this expedition.")
    elseif str == "expedition" then
      table.insert(messages, "We never even knew why we were here.  I")
      table.insert(messages, "thought we were sent to plan an invasion of")
      table.insert(messages, "the southern United States from Mexico, but")
      table.insert(messages, "then we ended up in the jungle ...")
    elseif str == "jungle" then
      table.insert(messages, "I hate the jungle.  It was never humid and")
      table.insert(messages, "sticky like this at home.")
    elseif str == "mother" or str == "father" or str == "home" or str == "germany" then
      table.insert(messages, "I don't know, I can't remember anything.")
      table.insert(messages, "Nothing.  Why do you keep asking questions?")
      table.insert(messages, "Why can't you leave me alone?")
    elseif str == "sorry" then
      table.insert(messages, "It's ok.  It's frustrating, being like this.")
    elseif str == "invasion" or str == "united" or str == "states" or str == "mexico" then
      table.insert(messages, "There was a lot of speculation about what")
      table.insert(messages, "we would do in Mexico, but we were all")
      table.insert(messages, "wrong- and still don't know the real answer.")
    elseif str == "friedrich" or str == "behrens" or str == "claude" or str == "joachim" or str == "gunther" then
      table.insert(messages, "That name sounds familiar, but I don't know")
      table.insert(messages, "why ...")
    elseif str == "muller" then
      table.insert(messages, "I remember that name ... for some reason I")
      table.insert(messages, "don't think I liked Muller, whoever he was.")
    else
      local rand = Game.random(2)
      if rand == 0 then
        table.insert(messages, "What?  WHAT?")
      else
        table.insert(messages, "I don't understand you.")
      end
    end
  end

  return messages
end

WalterLevel10 = {}

function WalterLevel10:get_greeting()
  local messages = {}
  table.insert(messages, "Who are you?  You want my gold, don't you?")
  table.insert(messages, "Don't take my gold!")

  return messages
end

function WalterLevel10:get_response(str)
  local messages = {}

  if str == "name" then
    table.insert(messages, "Walter.  I remember Muller saying my name")
    table.insert(messages, "when he sent me to find the ingots.  I hate")
    table.insert(messages, "Muller.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "Those slime things were everywhere,")
    table.insert(messages, "roaming the corridors in groups of three.  I")
    table.insert(messages, "ran as fast as I could, but they got me ...")
  elseif str == "gold" or str == "ingot" then
    table.insert(messages, "Don't take it, it's mine!  It's all I have left,")
    table.insert(messages, "all I have to look at.  There's plenty more ...")
  elseif str == "plenty" or str == "more" or str == "where" then
    table.insert(messages, "Somewhere a few ladders down there's a")
    table.insert(messages, "huge gold door Muller gave us the key for.")
    table.insert(messages, "There are eleven more ingots down there,")
    table.insert(messages, "don't take mine!  Get your own!")
  elseif str == "key" then
    table.insert(messages, "I had the key, but someone took it.  A group")
    table.insert(messages, "of people passed by, speaking Spanish, and")
    table.insert(messages, "their leader took it.")
  elseif str == "down" or str == "ladder" then
    table.insert(messages, "You'll find it easily enough, there's only one")
    table.insert(messages, "way to go.  There are invisible demons on")
    table.insert(messages, "the level below this one, watch out.  I")
    table.insert(messages, "escaped them.  I ran.")
  elseif str == "invisible" or str == "demons" or str == "them" then
    table.insert(messages, "We didn't meet them on the way down, but")
    table.insert(messages, "they were everywhere when I came back.  It")
    table.insert(messages, "was like everything was asleep and we")
    table.insert(messages, "slowly woke it up.")
  elseif str == "spanish" or str == "people" or str == "passed" then
    table.insert(messages, "They had weapons even better than our")
    table.insert(messages, "machine pistols.  I couldn't understand what")
    table.insert(messages, "they were saying.")
  elseif str == "muller" then
    table.insert(messages, "Muller sent us to get one ingot and a wooden")
    table.insert(messages, "box, he said they were extremely important.")
    table.insert(messages, "I was leaving though, there was no way I")
    table.insert(messages, "was going back down to try to find him.")
  elseif str == "box" or str == "cedar" or str == "wooden" then
    table.insert(messages, "Muller said we needed all twelve ingots, but")
    table.insert(messages, "that the box would duplicate things which")
    table.insert(messages, "were placed inside it so we should only get")
    table.insert(messages, "one.  We found the box ...")
  elseif str == "duplicate" or str == "copy" then
    table.insert(messages, "The box worked like he said, but the ingots")
    table.insert(messages, "wouldn't fit inside it.  I dropped it when I")
    table.insert(messages, "was attacked by the invisible demons, it")
    table.insert(messages, "was useless.  But I kept the ingot.")
  elseif str == "important" then
    table.insert(messages, "Muller was just greedy.  He was probably")
    table.insert(messages, "planning to kill us all and take the gold for")
    table.insert(messages, "himself.  I would have.")
  elseif str == "everything" then
    table.insert(messages, "Everything.  The slimes, those flying fish,")
    table.insert(messages, "the demons.  They woke up behind us and")
    table.insert(messages, "waited for me to return.")
  elseif str == "slime" or str == "ooze" or str == "ghoul" then
    table.insert(messages, "One of the oozes turned a corner in front of")
    table.insert(messages, "me while I was running from a ghoul.  I ran")
    table.insert(messages, "into him before I knew it ...")
  elseif str == "mine" then
    table.insert(messages, "No, it's MINE!  Don't take it!  Mine, mine,")
    table.insert(messages, "mine!")
  elseif str == "woke" or str == "awakened" or str == "asleep" then
    table.insert(messages, "The pyramid slowly awoke behind his,")
    table.insert(messages, "trapping us down here.")
  elseif str == "ran" or str == "run" or str == "alone" then
    table.insert(messages, "Running was my only defense down here,")
    table.insert(messages, "alone.")
  elseif str == "weapon" then
    table.insert(messages, "Their weapons fired faster and did more")
    table.insert(messages, "damage to those slime things.  I wish we'd")
    table.insert(messages, "had weapons like that.")
  elseif str == "leader" then
    table.insert(messages, "I couldn't understand what he was saying,")
    table.insert(messages, "but it seemed like he was expecting to find")
    table.insert(messages, "the key.")
  elseif str == "leaving" then
    table.insert(messages, "I was leaving as fast as I could.  I wasn't")
    table.insert(messages, "about to stay down here if I could help it ...")
  elseif str == "pyramid" or str == "here" then
    table.insert(messages, "I hate this place.")
  else
    local rand = Game.random(3)
    if rand == 0 then
      table.insert(messages, "I can't understand you.")
    elseif rand == 1 then
      table.insert(messages, "What are you trying to say?")
    else
      table.insert(messages, "You're not making any sense.")
    end
  end

  return messages
end

JohnLevel11 = {}

function JohnLevel11:get_greeting()
  local messages = {}
  table.insert(messages, "Hey man, we all thought you were dead!")
  table.insert(messages, "How'd you get down this far by yourself?")
  table.insert(messages, "Never mind.  I'm glad to see you, but hurry up")
  table.insert(messages, "and catch the others.")

  return messages
end

function JohnLevel11:get_response(str)
  local messages = {}

  if str == "name" then
    table.insert(messages, "You know my name, come on.  I'm John,")
    table.insert(messages, "remember?  You're joking, right?")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "After we'd been wandering around here for a")
    table.insert(messages, "few minutes, we were attacked by these")
    table.insert(messages, "invisible creatures.  Two of them got me.")
  elseif str == "nuclear" or str == "bomb" or str == "nuke" or str == "steven" or str == "others" then
    table.insert(messages, "Steven was carrying the bomb when they")
    table.insert(messages, "left.  But man, they're in serious trouble.")
    table.insert(messages, "You could see it.  They were losing hope.")
  elseif str == "authentication" or str == "code" then
    table.insert(messages, "Steven changed the code after you were lost,")
    table.insert(messages, "but I don't know what it is.")
  elseif str == "radio" or str == "beacon" or str == "extraction" then
    table.insert(messages, "I was carrying one of the extraction")
    table.insert(messages, "beacons, but they took it after I died.  They")
    table.insert(messages, "left my broken M-16.")
  elseif str == "invisible" or str == "monsters" or str == "creatures" or str == "monster" or str == "creature" then
    table.insert(messages, "We could see the creatures through the")
    table.insert(messages, "infra-red goggles, but it didn't help when")
    table.insert(messages, "they attacked.  I got hurt bad, the guys")
    table.insert(messages, "stayed with me until I died.")
  elseif str == "infra-red" or str == "goggles" then
    table.insert(messages, "I've got a pair, take mine.  It helps being")
    table.insert(messages, "able to see them, but the things are fast!  Be")
    table.insert(messages, "careful.")
  elseif str == "hope" or str == "trouble" then
    table.insert(messages, "Everybody was getting tired- nobody")
    table.insert(messages, "expected to be fighting the things we've")
    table.insert(messages, "been meeting.  It's too weird.  Hurry up and")
    table.insert(messages, "find them, they need you.")
  elseif str == "greg" then
    table.insert(messages, "If anybody survives, I bet it'll be Greg.  No")
    table.insert(messages, "offense, of course, it just seems like he")
    table.insert(messages, "could live through anything.")
  elseif str == "joking" then
    table.insert(messages, "You shouldn't joke with dead people, man,")
    table.insert(messages, "they're in no mood for it.")
  elseif str == "sorry" then
    table.insert(messages, "Yeah, it's ok.  Not like it bothers me much")
    table.insert(messages, "now.")
  else
    local rand = Game.random(2)
    if rand == 0 then
      table.insert(messages, "What?  I didn't understand.")
    else
      table.insert(messages, "I don't know anything about that, man.")
    end
  end

  return messages
end

AnonymousLevel12 = {}

function AnonymousLevel12:get_greeting()
  local messages = {}
  table.insert(messages, "All this gold surrounding me, and I've got no")
  table.insert(messages, "use for it.  Take it all, get it out of my sight.")

  return messages
end

function AnonymousLevel12:get_response(str)
  local messages = {}

  if str == "name" then
    table.insert(messages, "I can't remember it anymore.  Everything is")
    table.insert(messages, "slipping away.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "Walter shot me.  You should have seen his")
    table.insert(messages, "eyes when he saw the gold.  I knew he would")
    table.insert(messages, "try to leave without us, I just didn't think")
    table.insert(messages, "he'd kill me.")
  elseif str == "shot" or str == "walter" then
    table.insert(messages, "We'd already found the cedar box, and he")
    table.insert(messages, "wanted it all for himself.  I hope the")
    table.insert(messages, "creatures got him on the way out.  He")
    table.insert(messages, "couldn't leave without the gemstone,")
    table.insert(messages, "anyway.")
  elseif str == "gold" or str == "ingot" or str == "wealth" or str == "treasure" or str == "money" then
    table.insert(messages, "I overheard Muller saying that he wouldn't")
    table.insert(messages, "let us leave unless we were each carrying")
    table.insert(messages, "our weight in gold.")
  elseif str == "muller" then
    table.insert(messages, "This is all Muller's fault.  I hate him.")
  elseif str == "cedar" or str == "box" or str == "duplicate" or str == "copy" or str == "inside" or str == "item" then
    table.insert(messages, "The cedar box was supposed to be able to")
    table.insert(messages, "duplicate any item placed inside it.")
  elseif str == "germany" or str == "home" or str == "family" then
    table.insert(messages, "My family lived in Prague, Germany.")
  elseif str == "weight" then
    table.insert(messages, "Muller was a greedy bastard.")
  elseif str == "creatures" or str == "monsters" or str == "them" or str == "creature" or str == "monster" then
    table.insert(messages, "Haven't you seen them?  It takes them a")
    table.insert(messages, "while to wake up after a group passes")
    table.insert(messages, "through, but then they stay awake for years.")
  elseif str == "gem" or str == "gemstone" then
    table.insert(messages, "I overheard Muller speaking of a strange")
    table.insert(messages, "gemstone which would open the door that")
    table.insert(messages, "locked us inside the pyramid.")
  elseif str == "locked" or str == "door" then
    table.insert(messages, "You know, the door on the ground floor.")
  else
    local rand = Game.random(3)
    if rand == 0 then
      table.insert(messages, "Sorry, I don't understand what you mean.")
    elseif rand == 1 then
      table.insert(messages, "I don't remember anything about that.")
    else
      table.insert(messages, "I can't understand you.")
    end
  end

  return messages
end

AnonymousLevel14_1 = {}

function AnonymousLevel14_1:get_greeting()
  local messages = {}
  table.insert(messages, "They never came back.  Muller never brought")
  table.insert(messages, "any of them back.  They're all dead, even")
  table.insert(messages, "Muller.")

  return messages
end

function AnonymousLevel14_1:get_response(str)
  local messages = {}
  if str == "name" then
    table.insert(messages, "I never had a name.")
  elseif str == "death" or str == "die" or str == "dead" or str == "man" then
    table.insert(messages, "The man covering my back bolted when we")
    table.insert(messages, "were attacked.  One of those flying")
    table.insert(messages, "gas-filled monsters hit me from behind.")
  elseif str == "muller" then
    table.insert(messages, "Muller thought he knew everything about")
    table.insert(messages, "this place, but I guess he was wrong.  I")
    table.insert(messages, "guess he died for it, too.")
  elseif str == "they" or str == "all" then
    table.insert(messages, "All the people I came down here with.  We")
    table.insert(messages, "all wanted to leave, a long time before we")
    table.insert(messages, "reached this spot, but Muller dragged us on.")
  elseif
    str == "monster" or str == "flying" or str == "gas-filled" or str == "gas" or str == "nightmare" or
      str == "concussion"
   then
    table.insert(messages, "I spun around and pushed my MP-41 into it's")
    table.insert(messages, "squishy forehead and fired until it exploded.")
    table.insert(messages, "The concussion killed me.")
  elseif str == "mp-41" or str == "machine" or str == "pistol" then
    table.insert(messages, "Everybody who left after I died had an")
    table.insert(messages, "MP-41.  If you want one, just look for")
    table.insert(messages, "their bodies.  They never came back, so they're")
    table.insert(messages, "rotting around here somewhere ...")
  elseif str == "bodies" or str == "rotting" or str == "deserve" then
    table.insert(messages, "And they all deserve it, especially Muller.")
  elseif str == "pyramid" or str == "place" then
    table.insert(messages, "I hate it, I hate it.")
  else
    local rand = Game.random(2)
    if rand == 0 then
      table.insert(messages, "You don't make any sense.")
    else
      table.insert(messages, "I don't understand.")
    end
  end

  return messages
end

AnonymousLevel14_2 = {}

function AnonymousLevel14_2:get_greeting()
  local messages = {}
  table.insert(messages, "No, no!- NO!   Keep them away from me.")
  table.insert(messages, "Please!")

  return messages
end

function AnonymousLevel14_2:get_response(str)
  local messages = {}
  if str == "death" or str == "die" or str == "dead" or str == "corner" then
    table.insert(messages, "Don't let them get me again, it was horrible.")
    table.insert(messages, "Please!")
  elseif str == "they" or str == "monsters" or str == "creatures" or str == "monster" or str == "creature" then
    table.insert(messages, "Don't let them out, please, PLEASE!  Promise")
    table.insert(messages, "me you won't let them out!  You're going to")
    table.insert(messages, "let them out, I can tell ...")
  elseif str == "door" or str == "doors" then
    table.insert(messages, "Go ahead, open them!")
  elseif str == "muller" then
    table.insert(messages, "I was hiding in this corner when Muller died.")
    table.insert(messages, "This was all his fault.")
  else
    table.insert(messages, "No, no!- NO!   Keep them away from me.")
    table.insert(messages, "Please!")
  end

  return messages
end

FriedrichLevel14 = {}

function FriedrichLevel14:get_greeting()
  local messages = {}
  table.insert(messages, "Be careful, don't step on those arrows")
  table.insert(messages, "painted on the floor.  You don't want to find")
  table.insert(messages, "out what's behind those doors!")

  return messages
end

function FriedrichLevel14:get_response(str)
  local messages = {}
  if str == "name" then
    table.insert(messages, "My name is Friedrich.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "Muller, our commander, opened those doors")
    table.insert(messages, "by stepping on that painted rune.  At least")
    table.insert(messages, "twenty monsters came pouring out.")
  elseif str == "door" or str == "doors" or str == "painted" or str == "arrows" or str == "rune" then
    table.insert(messages, "Somehow stepping on the rune caused the")
    table.insert(messages, "three doors on the far wall to open.")
  elseif str == "monster" or str == "monsters" then
    table.insert(messages, "They killed us all.  The last four members of")
    table.insert(messages, "the expedition, unless Walter and whoever")
    table.insert(messages, "went with him survived.")
  elseif str == "muller" then
    table.insert(messages, "I was Muller's first officer on this")
    table.insert(messages, "expedition.  He revealed few of his plans to")
    table.insert(messages, "me, however.")
  elseif str == "expedition" or str == "plans" then
    table.insert(messages, "We were searching the pyramid and it's")
    table.insert(messages, "dungeons for what Muller described to me as")
    table.insert(messages, "'a small glass vial of immense power.'")
  elseif str == "walter" then
    table.insert(messages, "Muller gave Walter a gold key and sent him")
    table.insert(messages, "to recover a large amount of gold and a")
    table.insert(messages, "strange wooden box.")
  elseif str == "wooden" or str == "box" or str == "cedar" then
    table.insert(messages, "The box was made of cedar.  Muller didn't")
    table.insert(messages, "tell me what it was supposed to do, or what")
    table.insert(messages, "it had to do with the gold.")
  elseif str == "gold" or str == "ingot" or str == "key" or str == "treasure" or str == "reason" then
    table.insert(messages, "Muller maintained that there was some")
    table.insert(messages, "reason we needed the gold- other than his")
    table.insert(messages, "greed- but I never quite believed him.")
  elseif str == "immense" or str == "power" or str == "glass" or str == "vial" or str == "ornate" then
    table.insert(messages, "He wouldn't want me to tell you this, but he")
    table.insert(messages, "was convinced that it contained the essence")
    table.insert(messages, "of an imprisoned demon.")
  elseif str == "demon" or str == "imprisoned" then
    table.insert(messages, "If it was ever released, it would cause")
    table.insert(messages, "destruction on a massive scale.  Muller")
    table.insert(messages, "wanted to use it for the war, of course.  It")
    table.insert(messages, "was all nonsense.")
  elseif str == "war" or str == "destruction" or str == "glory" then
    table.insert(messages, "Muller was always thinking about the war,")
    table.insert(messages, "and about the glory he would win for the")
    table.insert(messages, "Fatherland.")
  elseif str == "fatherland" then
    table.insert(messages, "Germany, of course.  Sometimes I wonder")
    table.insert(messages, "what happened after the war was started.  It")
    table.insert(messages, "was 1938 when we came to Mexico.")
  elseif str == "pyramid" or str == "dungeons" or str == "catacombs" then
    table.insert(messages, "Who would have thought there was")
    table.insert(messages, "someplace on Earth like this ...")
  elseif str == "1938" or str == "mexico" then
    table.insert(messages, "It was 1938 when we came to Mexico.")
  else
    local rand = Game.random(2)
    if rand == 0 then
      table.insert(messages, "Sorry, I didn't understand you.")
    else
      table.insert(messages, "What?")
    end
  end

  return messages
end

MullerLevel14 = {}

function MullerLevel14:get_greeting()
  local messages = {}
  table.insert(messages, "I knew that someone would eventually")
  table.insert(messages, "follow us.  It's been over fifty years, hasn't")
  table.insert(messages, "it?  Is the war still going on?")

  return messages
end

function MullerLevel14:get_response(str)
  local messages = {}
  if str == "name" or str == "muller" then
    table.insert(messages, "I am Muller, these are the last of my men.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "We were attacked by many strange")
    table.insert(messages, "monsters, and my men panicked and we were")
    table.insert(messages, "killed.")
  elseif str == "walter" then
    table.insert(messages, "I sent Walter to retrieve something, but it")
    table.insert(messages, "is a worthless archaeological artifact.")
    table.insert(messages, "You'd have no interest in it.")
  elseif str == "friedrich" then
    table.insert(messages, "Friedrich was my second in command.  He")
    table.insert(messages, "was the only one who stood by me and at the")
    table.insert(messages, "end.  All the others tried to run.")
  elseif str == "door" or str == "doors" or str == "rune" then
    table.insert(messages, "That rune painted on the floor will open the")
    table.insert(messages, "three doors in front of you and open the")
    table.insert(messages, "treasure room.  We killed all the monsters")
    table.insert(messages, "inside, there's no danger.")
  elseif str == "alien" or str == "pipes" or str == "pyramid" or str == "base" then
    table.insert(messages, "You probably already know how to use the")
    table.insert(messages, "pipes.  The doors at the base of the pyramid")
    table.insert(messages, "are almost always sealed and there's no")
    table.insert(messages, "other way to get down.")
  elseif str == "gold" or str == "key" then
    table.insert(messages, "I gave Walter a gold key, and told him he")
    table.insert(messages, "was looking for a fortune in gold, but I was")
    table.insert(messages, "only appealing to his sense of greed.  There")
    table.insert(messages, "is no gold.")
  elseif str == "wooden" or str == "cedar" or str == "box" or str == "copy" or str == "duplicate" then
    table.insert(messages, "People have told you about the cedar box?  It")
    table.insert(messages, "is an art object of great value, but is")
    table.insert(messages, "otherwise useless.")
  elseif str == "yes" then
    if not self.war or self.war == "yes" then
      table.insert(messages, "I thought the war might continue for a great")
      table.insert(messages, "length of time.  How are your people holding")
      table.insert(messages, "off the invasion of the States?")
    else
      table.insert(messages, "Make up your mind.  Is the second great war")
      table.insert(messages, "still being fought?")
    end
    self.war = "yes"
  elseif str == "no" then
    if not self.war or self.war == "no" then
      table.insert(messages, "How can I trust you that the war is over?")
      table.insert(messages, "You must be losing, Yankee, or you would not")
      table.insert(messages, "lie like that.")
    else
      table.insert(messages, "Make up your mind.  Is the second great war")
      table.insert(messages, "still being fought?")
    end
    self.war = "no"
  elseif str == "creatures" or str == "monsters" or str == "creature" or str == "monster" or str == "ambush" then
    table.insert(messages, "We didn't expect to find strange beasts like")
    table.insert(messages, "we discovered here.  We were entirely")
    table.insert(messages, "unprepared.")
  elseif str == "munich" or str == "university" or str == "archaeological" or str == "archaeology" then
    table.insert(messages, "We were looking for several lost Mayan")
    table.insert(messages, "artifacts.")
  elseif str == "men" or str == "expedition" then
    table.insert(messages, "We were sent by a university in Munich on an")
    table.insert(messages, "archaeological expedition.")
  elseif str == "war" then
    table.insert(messages, "What war?  The second great war.")
  elseif str == "relics" or str == "treasure" or str == "artifacts" or str == "mayan" or str == "art" or str == "object" then
    table.insert(messages, "There is a fortune in ancient relics behind")
    table.insert(messages, "these doors.  We almost retrieved them, but")
    table.insert(messages, "died after we had killed all the monsters")
    table.insert(messages, "guarding it.")
  elseif str == "blue" or str == "yellow" or str == "violet" or str == "crystal" then
    table.insert(messages, "I know nothing about the crystals.")
  elseif str == "hans" then
    table.insert(messages, "Hans was a fool.")
  elseif str == "joachim" then
    table.insert(messages, "Joachim was lazy and insubordinate.")
  elseif str == "demon" or str == "imprisoned" or str == "vial" or str == "glass" then
    table.insert(messages, "No one should have told you about the vial!")
    table.insert(messages, "Who said that?  Friedrich?  I'll kill him ...")
  elseif str == "kill" then
    table.insert(messages, "Or maybe not.")
  elseif str == "germany" then
    table.insert(messages, "Our expedition was from Germany.")
  elseif str == "grenades" or str == "grenade" then
    table.insert(messages, "I allowed the men to use their grenades")
    table.insert(messages, "early, and it didn't leave us any for later,")
    table.insert(messages, "like we needed.")
  elseif str == "something" or str == "nothing" or str == "interest" then
    table.insert(messages, "Nothing you'd be interested in.")
  else
    local rand = Game.random(3)
    if rand == 0 then
      table.insert(messages, "Sorry, I can't help you with that.")
    elseif rand == 1 then
      table.insert(messages, "I don't understand what you mean.")
    else
      table.insert(messages, "Try to be more clear, I don't understand.")
    end
  end

  return messages
end

ThomasLevel14 = {}

function ThomasLevel14:get_greeting()
  local messages = {}
  table.insert(messages, "Don't open those doors, leave now!  Leave")
  table.insert(messages, "while you still can!")

  return messages
end

function ThomasLevel14:get_response(str)
  local messages = {}
  if str == "name" then
    table.insert(messages, "My name is Thomas.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "Muller stepped on that rune in front of the")
    table.insert(messages, "center door.  It killed us all.")
  elseif str == "door" or str == "doors" then
    table.insert(messages, "There are hundreds of monsters in there, and")
    table.insert(messages, "they come swarming out and surround you.")
    table.insert(messages, "There's no way to kill them all!")
  elseif str == "rune" then
    table.insert(messages, "The rune opens all three doors, and even")
    table.insert(messages, "with one person with a machine pistol")
    table.insert(messages, "covering each door it was hopeless.")
  elseif
    str == "monsters" or str == "nightmare" or str == "ghoul" or str == "ooze" or str == "flying" or str == "beast" or
      str == "creature" or
      str == "humanoid" or
      str == "slime" or
      str == "monster" or
      str == "creatures"
   then
    table.insert(messages, "All kinds of monsters.  Those ghastly pale")
    table.insert(messages, "humanoids, the flying beasts, the slimes.  It")
    table.insert(messages, "was too much.  We only killed a few.")
  elseif str == "machine" or str == "pistol" or str == "mp-41" then
    table.insert(messages, "Do you need one?  They're all over this room,")
    table.insert(messages, "but we've used most of the ammunition,")
    table.insert(messages, "sorry.")
  elseif str == "muller" then
    table.insert(messages, "Muller hardly even warned us before he")
    table.insert(messages, "opened the doors.  I think he knew what was")
    table.insert(messages, "going to happen, which makes him even more")
    table.insert(messages, "stupid.")
  elseif str == "friedrich" or str == "behrens" or str == "claude" or str == "joachim" or str == "gunther" then
    table.insert(messages, "He's dead.  They're all dead.  Muller should")
    table.insert(messages, "have turned back long before there were only")
    table.insert(messages, "four of us left.  We all wanted him to.")
  elseif str == "ammunition" or str == "magazine" or str == "bullets" or str == "bullet" or str == "magazines" then
    table.insert(messages, "Especially when using the MP-41, you can")
    table.insert(messages, "run out of ammunition really quick in this")
    table.insert(messages, "place.")
  else
    local rand = Game.random(2)
    if rand == 0 then
      table.insert(messages, "Hurry, leave now!  Stop talking to me.")
    else
      table.insert(messages, "Get out of here, now!  Run!")
    end
  end

  return messages
end

EdLevel15 = {}

function EdLevel15:get_greeting()
  local messages = {}
  table.insert(messages, "We gave you up for dead after the drop, I'm")
  table.insert(messages, "glad you made it.  I wish I could help you.")

  return messages
end

function EdLevel15:get_response(str)
  local messages = {}
  if str == "name" or str == "ed" then
    table.insert(messages, "This is Ed, who do I look like?  Sorry, I")
    table.insert(messages, "guess it might be sort of hard to tell.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "I accidentally triggered one of the doors")
    table.insert(messages, "after we came down the ladder.  One of")
    table.insert(messages, "those green things cooked me.  The guys")
    table.insert(messages, "carried me here.")
  elseif str == "bomb" or str == "nuke" or str == "greg" then
    table.insert(messages, "About ten minutes after everybody left, I")
    table.insert(messages, "saw Greg come running through here.  He was")
    table.insert(messages, "carrying the bomb.")
  elseif str == "radio" or str == "beacon" or str == "extraction" then
    table.insert(messages, "The team had all three beacons when they")
    table.insert(messages, "left me here.  I don't know where they are")
    table.insert(messages, "now.")
  elseif str == "steven" then
    table.insert(messages, "Steven was furious after your 'chute didn't")
    table.insert(messages, "open.  It set the tone for the whole mission.")
  elseif str == "sean" or str == "jason" or str == "darren" then
    table.insert(messages, "I don't know what happened to him, or most")
    table.insert(messages, "of the others for that matter.")
  elseif str == "john" then
    table.insert(messages, "I don't remember what happened to John.")
    table.insert(messages, "I'm starting to forget lots of things.")
  elseif str == "nightmare" or str == "green" or str == "things" then
    table.insert(messages, "Yeah, one of those killed me.  I'll never see")
    table.insert(messages, "Anna again.  Promise me you'll call her when")
    table.insert(messages, "you get back ...")
  elseif str == "anna" then
    table.insert(messages, "Don't joke with me, man, please call her.")
  elseif str == "parachute" or str == "paradrop" or str == "drop" then
    table.insert(messages, "This mission started out bad and only got")
    table.insert(messages, "worse.  We had a horrible getting this far")
    table.insert(messages, "down, and it only gets worse.")
  elseif str == "doors" or str == "door" then
    table.insert(messages, "Man, I hate the doors in this place.  Half of")
    table.insert(messages, "them don't open, but the half that does open")
    table.insert(messages, "makes you wish they'd all stay shut.")
  elseif str == "team" or str == "guys" then
    table.insert(messages, "We lost John a few hours before I died, and")
    table.insert(messages, "that left Steven, Greg, Jason, Darren and")
    table.insert(messages, "Sean.  Greg was the only one I ever saw")
    table.insert(messages, "again.")
  elseif str == "promise" then
    table.insert(messages, "Ok.  That makes me feel better.  You've got")
    table.insert(messages, "to make it out, now.  Don't forget.")
  elseif str == "cooked" or str == "unpleasent" or str == "sensation" then
    table.insert(messages, "An unpleasant sensation, I can assure you.")
  elseif str == "place" or str == "pyramid" or str == "hole" then
    table.insert(messages, "I'd rather be in Bosnia, or even Somalia,")
    table.insert(messages, "rather than be dead at the bottom of this")
    table.insert(messages, "hole.")
  elseif str == "bosnia" or str == "somalia" or str == "joke" then
    table.insert(messages, "Ok, ok.  Bad joke")
  elseif str == "help" then
    table.insert(messages, "I'm sort of incapacitated or I'd help, I mean.")
  elseif str == "incapacitated" then
    table.insert(messages, "That is, dead.")
  elseif str == "mission" then
    table.insert(messages, "You remember the mission, don't you?  Don't")
    table.insert(messages, "mess with me, man ...")
  else
    local rand = Game.random(3)
    if rand == 0 then
      table.insert(messages, "I didn't understand what you said.")
    elseif rand == 1 then
      table.insert(messages, "I don't know anything about that.")
    else
      table.insert(messages, "Say that again?")
    end
  end

  return messages
end

StevenLevel15 = {}

function StevenLevel15:get_greeting()
  local messages = {}
  table.insert(messages, "Wow, we all thought you were dead.  It's a")
  table.insert(messages, "good thing you made it, you're probably the")
  table.insert(messages, "last hope now.")

  return messages
end

function StevenLevel15:get_response(str)
  local messages = {}
  if str == "name" or str == "steven" then
    table.insert(messages, "I'm Steven.  If I weren't dead I'd be insulted")
    table.insert(messages, "that you didn't recognize me.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "There's this huge blue creature around the")
    table.insert(messages, "corner, watch out.  I was the first one to get")
    table.insert(messages, "burned.  I'm glad we left Greg outside the")
    table.insert(messages, "door.")
  elseif str == "nuclear" or str == "bomb" or str == "nuke" or str == "greg" then
    table.insert(messages, "Greg was carrying the bomb when he got")
    table.insert(messages, "separated from us by that sliding door, we")
    table.insert(messages, "tried to stop it from closing but it was too")
    table.insert(messages, "strong.  Find him, he needs your help.")
  elseif str == "authentication" or str == "code" then
    table.insert(messages, "Thanks for reminding me, I almost forgot.")
    table.insert(messages, "We changed the first three digits of the code")
    table.insert(messages, "from '287' to '".. BombCodeStart .. "' because you were")
    table.insert(messages, "separated from us.")
  elseif str == "radio" or str == "beacon" or str == "extraction" then
    table.insert(messages, "I've got a beacon, and I think it survived the")
    table.insert(messages, "fire.  I hope it still works.")
  elseif str == "fire" or str == "blue" or str == "thing" then
    table.insert(messages, "You'll see soon enough, I can't really")
    table.insert(messages, "describe what happened.")
  elseif str == "greg" then
    table.insert(messages, "Greg was carrying the bomb when he got")
    table.insert(messages, "separated from us by that sliding door, we")
    table.insert(messages, "tried to stop it from closing but it was too")
    table.insert(messages, "strong.  Find him, he needs your help.")
  elseif str == "john" then
    table.insert(messages, "We lost john a day ago when we were")
    table.insert(messages, "attacked by these invisible monsters.")
  elseif str == "ed" then
    table.insert(messages, "Ed is somewhere down the corridor behind")
    table.insert(messages, "me, I heard him die right after I did.")
  else
    local rand = Game.random(3)
    if rand == 0 then
      table.insert(messages, "I don't understand what you mean.")
    elseif rand == 1 then
      table.insert(messages, "Sorry, say that again?")
    else
      table.insert(messages, "I can't help you with that.")
    end
  end

  return messages
end

JasonLevel15 = {}

function JasonLevel15:get_greeting()
  local messages = {}
  table.insert(messages, "Flames, I see flames everywhere.")

  return messages
end

function JasonLevel15:get_response(str)
  local messages = {}
  if str == "name" then
    table.insert(messages, "My name doesn't matter anymore.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "That huge, blue grinning thing torched us all.")
  elseif str == "flames" or str == "torch" or str == "blue" or str == "grinning" then
    table.insert(messages, "We never stopped firing at it.  Back up")
    table.insert(messages, "around a corner, fire, back up, fire.  It's")
    table.insert(messages, "gotta be hurting.  You can kill it.")
  elseif str == "hurting" or str == "kill" then
    table.insert(messages, "We saw a little blood, our bullets were")
    table.insert(messages, "hurting it- but it didn't seem to care.")
  elseif str == "thing" or str == "it" then
    table.insert(messages, "I don't know if you can kill it, man, but try")
    table.insert(messages, "as hard as you can.")
  elseif str == "jason" then
    table.insert(messages, "Of course I'm jason, man.")
  elseif str == "pathways" then
    table.insert(messages, "I'm coding this script in the afternoon of")
    table.insert(messages, "July 22nd, do you think we'll make MacWorld")
    table.insert(messages, "on August 3rd?")
  else
    table.insert(messages, "Flames, I see flames everywhere.")
  end

  return messages
end

DarrenLevel15 = {}

function DarrenLevel15:get_greeting()
  local messages = {}
  table.insert(messages, "I ran, I ran all the way back here.  But it")
  table.insert(messages, "followed me.  It killed everyone else.")

  return messages
end

function DarrenLevel15:get_response(str)
  local messages = {}
  if str == "name" then
    table.insert(messages, "My name doesn't matter.  Yours won't either,")
    table.insert(messages, "in a moment.")
  elseif str == "dankness" then
    table.insert(messages, "I'm coding this script in the evening of")
    table.insert(messages, "January 4th, 2019.  What a waste of time.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "I ran, I ran all the way back here.  But it")
    table.insert(messages, "followed me.  It killed everyone else.")
  elseif str == "it" or str == "what" or str == "ran" or str == "him" then
    table.insert(messages, "It, IT.  All I see are flames.  You'll find out")
    table.insert(messages, "fast enough, you're locked in here too, just")
    table.insert(messages, "like we were.")
  elseif
    str == "everyone" or str == "steven" or str == "greg" or str == "ed" or str == "americans" or str == "soldiers" or
      str == "we"
   then
    table.insert(messages, "Everyone's dead.  Greg, Steven, Ed.  You too.")
    table.insert(messages, "You shouldn't have come down here.  You'll")
    table.insert(messages, "never leave now.")
  elseif str == "flames" or str == "fire" or str == "burning" or str == "searing" then
    table.insert(messages, "Burning and searing.  All I remember is")
    table.insert(messages, "smoke and fire.")
  elseif str == "locked" then
    table.insert(messages, "... and the only way to leave is through that")
    table.insert(messages, "thing- good luck!")
  elseif
    str == "bomb" or str == "nuke" or str == "beacon" or str == "code" or str == "grenade" or str == "launcher" or
      str == "goggles" or
      str == "m-79" or
      str == "infra-red" or
      str == "infra" or
      str == "red"
   then
    table.insert(messages, "Forget that, man!  Try to get out of here,")
    table.insert(messages, "maybe you can make it, who knows.  But")
    table.insert(messages, "forget that!")
  else
    local rand = Game.random(2)
    if rand == 0 then
      table.insert(messages, "I don't know anything about that anymore.")
    else
      table.insert(messages, "I don't understand ...")
    end
  end

  return messages
end

SeanLevel15 = {}

function SeanLevel15:get_greeting()
  local messages = {}
  table.insert(messages, "Beware the flames!  You need to find Greg.")
  table.insert(messages, "How'd you get down the ladder at the base of")
  table.insert(messages, "the pyramid?  Those doors shut behind us.")

  return messages
end

function SeanLevel15:get_response(str)
  local messages = {}
  if str == "name" or str == "sean" then
    table.insert(messages, "I'm Sean, man, who do you think I am?  Are")
    table.insert(messages, "you sure you're ok?")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "We all died by fire.  Darren was the last, but")
    table.insert(messages, "after I died it chased him around the corner")
    table.insert(messages, "into that dead end.")
  elseif str == "greg" or str == "bomb" or str == "nuke" or str == "code" or str == "authentication" then
    table.insert(messages, "Greg has the bomb.  You need to find him and")
    table.insert(messages, "complete the mission.  Steven changed the")
    table.insert(messages, "code, I don't know what it is.")
  elseif str == "ed" then
    table.insert(messages, "Ed bought it as soon as we reached this")
    table.insert(messages, "level.  It saved him the trouble of dying")
    table.insert(messages, "here, with the rest of us.")
  elseif str == "john" then
    table.insert(messages, "John died before we realized we needed the")
    table.insert(messages, "infra-red goggles to see those snakes a few")
    table.insert(messages, "levels ago.")
  elseif str == "steven" then
    table.insert(messages, "Steve was the first one to die.  You'll find")
    table.insert(messages, "his body up the corridor a bit.  Be careful.")
  elseif str == "radio" or str == "beacon" or str == "extraction" then
    table.insert(messages, "I hope you can find an intact beacon, or")
    table.insert(messages, "you're really toast.")
  elseif str == "fire" or str == "brimstone" or str == "flames" then
    table.insert(messages, "You'll find the flames soon enough.")
  elseif str == "it" or str == "thing" then
    table.insert(messages, "You'll find it soon enough.")
  elseif str == "doors" or str == "door" or str == "base" or str == "pyramid" or str == "down" then
    table.insert(messages, "The first few doors we walked through in")
    table.insert(messages, "this pyramid sealed behind us, and we had no")
    table.insert(messages, "way to go but down.")
  elseif str == "mission" or str == "remember" then
    table.insert(messages, "Yes, the mission.  Don't tell me you don't")
    table.insert(messages, "remember the mission ...")
  elseif str == "careful" then
    table.insert(messages, "That thing will probably attack you when")
    table.insert(messages, "you get close to Steven's body, so watch out.")
  else
    local rand = Game.random(3)
    if rand == 0 then
      table.insert(messages, "What?  I don't understand.")
    elseif rand == 1 then
      table.insert(messages, "Say again?")
    else
      table.insert(messages, "Sorry, man, you're not making any sense.")
    end
  end

  return messages
end

GregLevel17 = {}

function GregLevel17:get_greeting()
  local messages = {}
  table.insert(messages, "Hey, welcome back from the dead.  I was")
  table.insert(messages, "wondering why you weren't around when I")
  table.insert(messages, "showed up.  Is everybody else dead?  I")
  table.insert(messages, "thought so.")

  return messages
end

function GregLevel17:get_response(str)
  local messages = {}
  if str == "name" or str == "greg" then
    table.insert(messages, "This is Greg, dude.  I guess maybe it's hard")
    table.insert(messages, "to recognize me in this state, that's ok.")
  elseif
    str == "death" or str == "die" or str == "dead" or str == "state" or str == "bullets" or str == "m-16" or
      str == "magazine"
   then
    table.insert(messages, "Those spider things were all around me, but")
    table.insert(messages, "I didn't stop firing until I ran out of bullets.")
    table.insert(messages, "Then something hit me like a dish washer-")
    table.insert(messages, "it must have been one of those zombies.")
  elseif str == "nuclear" or str == "bomb" or str == "nuke" then
    table.insert(messages, "I hid the bomb inside one of those exploding")
    table.insert(messages, "pods directly south of here, right before I")
    table.insert(messages, "died.  Somehow it just enveloped it, without")
    table.insert(messages, "blowing up.")
  elseif str == "authentication" or str == "code" or str == "steven" then
    table.insert(messages, "Steven changed the code after you were lost,")
    table.insert(messages, "but I never knew what it was.  Did you find")
    table.insert(messages, "Steven?  Did he tell you?")
  elseif str == "radio" or str == "beacon" or str == "extraction" then
    table.insert(messages, "I don't have a beacon.  I got cut off from the")
    table.insert(messages, "rest of the group two levels ago, and they")
    table.insert(messages, "had all three.  I hope you found one, you'll")
    table.insert(messages, "need it.")
  elseif str == "exploding" or str == "spore" or str == "pod" or str == "heat" or str == "trigger" then
    table.insert(messages, "I think the pods are triggered by heat, which")
    table.insert(messages, "is why the bomb- or the monsters for that")
    table.insert(messages, "matter- don't set them off.")
  elseif str == "spider" or str == "spiders" or str == "monster" or str == "goo" or str == "web" or str == "sticky" then
    table.insert(messages, "Spiders.  They're everywhere.  Can't stand")
    table.insert(messages, "'em.")
  elseif str == "dish" or str == "washer" or str == "earthquake" then
    table.insert(messages, "Yeah, like a dish washer dropped from three")
    table.insert(messages, "stories or something.  I don't even remember")
    table.insert(messages, "getting hit before that.  I was spanking them")
    table.insert(messages, "until I died.")
  elseif str == "street" or str == "fighter" then
    table.insert(messages, "Man, I'll never get to play Street Fighter")
    table.insert(messages, "again.  But Jason always beat me after I got")
    table.insert(messages, "that big bruise on my brain, so I guess it's")
    table.insert(messages, "no big loss.")
  elseif str == "john" or str == "ed" or str == "everybody" then
    table.insert(messages, "I think everybody's dead.  You're the last")
    table.insert(messages, "hope.  You've got to find the bomb and")
    table.insert(messages, "detonate it.")
  elseif str == "zombie" or str == "zombies" or str == "ghast" then
    table.insert(messages, "Man, I hate those zombie things.  You've got")
    table.insert(messages, "to nail them as soon as they appear to stop")
    table.insert(messages, "them from causing an earthquake.  They can")
    table.insert(messages, "use that power even when they can't see")
    table.insert(messages, "you, so watch out!")
  elseif str == "ninjas" then
    table.insert(messages, "Ninjas, too.  They're everywhere.")
  else
    local rand = Game.random(3)
    if rand == 0 then
      table.insert(messages, "I don't understand what you mean.")
    elseif rand == 1 then
      table.insert(messages, "You're not making any sense.")
    else
      table.insert(messages, "Say that again?")
    end
  end

  return messages
end

PedroLevel18 = {}

function PedroLevel18:get_greeting()
  local messages = {}
  local suffocation_in_progress = true
  for plat in Platforms() do
    if plat.polygon.index == 964 and plat.polygon.floor.height == 0 then
      suffocation_in_progress = false
    end
  end
  if suffocation_in_progress then
    table.insert(messages, "I know what's going to happen now: you're")
    table.insert(messages, "going to suffocate here, just like me.  The")
    table.insert(messages, "doors won't open for hours.")
  else
    table.insert(messages, "I don't understand how you can still be alive,")
    table.insert(messages, "I just don't understand ...")
  end

  return messages
end

function PedroLevel18:get_response(str)
  local messages = {}
  if str == "name" then
    table.insert(messages, "My name is Pedro.")
  elseif str == "death" or str == "die" or str == "dead" or str == "suffocate" then
    table.insert(messages, "I was trapped here, like you, and suffocated.")
    table.insert(messages, "It was very painful.  You should consider ...")
    table.insert(messages, "the alternatives.")
  elseif str == "door" or str == "doors" or str == "hours" or str == "open" or str == "oxygen" or str == "air" then
    table.insert(messages, "Long after you've used up all the oxygen in")
    table.insert(messages, "this tiny room, the doors will open.  Just")
    table.insert(messages, "like they did after I died.  They will open and")
    table.insert(messages, "wait for someone else ...")
  elseif str == "room" or str == "trapped" then
    table.insert(messages, "Somehow my companions got through, before")
    table.insert(messages, "the door shut, but I was trapped inside.")
  elseif str == "companions" or str == "friends" then
    table.insert(messages, "I was the last in line of six men, and the")
    table.insert(messages, "door slammed shut right as I was about to")
    table.insert(messages, "pass out of the room, trapping me.  They")
    table.insert(messages, "tried, I heard them, but there was no way to")
    table.insert(messages, "open the door.")
  elseif str == "consider" or str == "painful" or str == "alternatives" or str == "imagination" then
    table.insert(messages, "I'll leave that up to your imagination.")
  elseif
    str == "snake" or str == "snakebite" or str == "bite" or str == "venom" or str == "poison" or str == "juan" or
      str == "jungle"
   then
    table.insert(messages, "Juan got bitten by a snake none of us")
    table.insert(messages, "recognized in the jungle, a day before we")
    table.insert(messages, "found the pyramid.  He slowly got worse and")
    table.insert(messages, "worse, but he outlived me ...")
  elseif str == "six" or str == "men" or str == "group" then
    table.insert(messages, "I can only remember Juan, who was slowly")
    table.insert(messages, "dying of a snakebite in the jungle, Javier and")
    table.insert(messages, "Carlos.")
  elseif str == "javier" or str == "leader" or str == "idea" then
    table.insert(messages, "Javier was the leader of our little group.  It")
    table.insert(messages, "was his idea to come here.")
  elseif str == "carlos" then
    table.insert(messages, "I didn't know Carlos very well.")
  else
    local rand = Game.random(2)
    if rand == 0 then
      table.insert(messages, "What?")
    else
      table.insert(messages, "I don't understand you.")
    end
  end

  return messages
end

JuanLevel19 = {}

function JuanLevel19:get_greeting()
  local messages = {}
  table.insert(messages, "Who are you?  What's happening?  I thought I")
  table.insert(messages, "was dead- are you just a dream?  I haven't")
  table.insert(messages, "seen a living person in years.")

  return messages
end

function JuanLevel19:get_response(str)
  local messages = {}
  if str == "name" or str == "juan" then
    table.insert(messages, "I think my name is Juan.  I can't remember")
    table.insert(messages, "any of my companions names.")
  elseif str == "death" or str == "die" or str == "dead" or str == "jungle" then
    table.insert(messages, "I was poisoned by a venomous snake in the")
    table.insert(messages, "jungle.  Down here, two days later, I")
    table.insert(messages, "suddenly became weak and collapsed.  I died")
    table.insert(messages, "quickly.")
  elseif str == "dream" or str == "lonely" then
    table.insert(messages, "Sometimes I have the most horrible dreams.")
    table.insert(messages, "Or maybe they are real.  Do dead men dream?")
  elseif str == "living" or str == "person" or str == "years" then
    table.insert(messages, "It seems like forever since my companions")
    table.insert(messages, "and I passed through here.")
  elseif str == "pedro" then
    table.insert(messages, "Pedro was trapped behind a door on a higher")
    table.insert(messages, "level.  We tried to get him out, but we")
    table.insert(messages, "couldn't move the door, so we left.  I wonder")
    table.insert(messages, "what happened ...")
  elseif str == "snake" or str == "venom" or str == "poison" then
    table.insert(messages, "I don't know what kind of snake it was that")
    table.insert(messages, "got me in the jungle.  It was a very slow")
    table.insert(messages, "venom, finally becoming potent right before")
    table.insert(messages, "our group was ambushed.")
  elseif str == "group" or str == "companions" or str == "friends" then
    table.insert(messages, "I was part of a six-man group looking for")
    table.insert(messages, "some sort of enchanted bottle- I never")
    table.insert(messages, "really believed it.  But we were ambushed")
    table.insert(messages, "here, and all died.")
  elseif str == "green" or str == "humanoid" or str == "slimes" or str == "monsters" or str == "creatures" then
    table.insert(messages, "They killed and then absorbed everyone,")
    table.insert(messages, "until only their weapons were left.  Maybe")
    table.insert(messages, "Javier and Carlos escaped, but I doubt it.  I")
    table.insert(messages, "ran back here and hid.")
  elseif str == "ambush" or str == "attack" then
    table.insert(messages, "These green, humanoid slimes attacked us,")
    table.insert(messages, "and devoured everyone but myself.  For some")
    table.insert(messages, "reason they completely ignored me, and took")
    table.insert(messages, "my friends.")
  elseif str == "javier" or str == "carlos" then
    table.insert(messages, "He ran past the monsters and around a")
    table.insert(messages, "corner.  I don't know if he made it or not.")
  elseif str == "enchanted" or str == "bottle" then
    table.insert(messages, "It was all Javier's idea.  He said the bottle")
    table.insert(messages, "held great power, and that we would find")
    table.insert(messages, "much gold on the way.")
  elseif str == "gold" then
    table.insert(messages, "We didn't find any gold, and I doubt Javier")
    table.insert(messages, "ever found his bottle.  We were too greedy.")
  elseif str == "power" or str == "destructive" then
    table.insert(messages, "Javier was obsessed with power.  From what")
    table.insert(messages, "he said, I gathered the type he was looking")
    table.insert(messages, "for was of the destructive sort.")
  elseif str == "absorbed" or str == "devoured" then
    table.insert(messages, "It was horrible, watching their bodies being")
    table.insert(messages, "pushed into those green thing's chest and")
    table.insert(messages, "disappear.")
  elseif str == "weapons" then
    table.insert(messages, "You should be able to find their weapons, if")
    table.insert(messages, "someone else hasn't taking them.  It's")
    table.insert(messages, "nearby.")
  elseif str == "greed" then
    table.insert(messages, "Greed is why I died.")
  else
    local rand = Game.random(2)
    if rand == 0 then
      table.insert(messages, "I don't understand what you mean.")
    else
      table.insert(messages, "You're not making sense.")
    end
  end

  return messages
end

JavierLevel23 = {}

function JavierLevel23:get_greeting()
  local messages = {}
  table.insert(messages, "Uncorking that vial was the biggest mistake")
  table.insert(messages, "I ever made in my life.")

  return messages
end

function JavierLevel23:get_response(str)
  local messages = {}
  if str == "name" or str == "javier" then
    table.insert(messages, "My name is Javier.  That's Carlos, over there")
    table.insert(messages, "without his head.")
  elseif str == "death" or str == "die" or str == "dead" then
    table.insert(messages, "I couldn't wait to find out what was inside.")
    table.insert(messages, "The old man told me it was powerful, I just")
    table.insert(messages, "didn't understand what he meant.")
  elseif str == "vial" or str == "bottle" or str == "uncork" or str == "glass" or str == "ornate" then
    table.insert(messages, "The old man said it contained the trapped")
    table.insert(messages, "spirit of some powerful being.  I didn't know")
    table.insert(messages, "how right he was.")
  elseif str == "carlos" then
    table.insert(messages, "Carlos never really wanted to come, I'm")
    table.insert(messages, "totally responsible for his death.  And the")
    table.insert(messages, "others, too.")
  elseif str == "old" or str == "man" then
    table.insert(messages, "He was a friend's grandfather.  When he was")
    table.insert(messages, "young, a group of Germans camped near his")
    table.insert(messages, "village and he spied on them ...")
  elseif str == "germans" or str == "spy" or str == "camp" or str == "spied" then
    table.insert(messages, "They were looking for this vial that killed")
    table.insert(messages, "me.  He stole their maps and copied them.")
    table.insert(messages, "He gave them to us forty years later.")
  elseif str == "maps" then
    table.insert(messages, "The maps I had have rotted by now.  They")
    table.insert(messages, "were mostly useless, anyway, but they told")
    table.insert(messages, "us the only way to escape this place.")
  elseif str == "gold" or str == "key" or str == "body" then
    table.insert(messages, "We took the gold key from a dead body, far")
    table.insert(messages, "above us, but we never found the gold door")
    table.insert(messages, "which it opened.")
  elseif str == "others" then
    table.insert(messages, "All six of them.  And they're all dead")
    table.insert(messages, "because of me and this stupid, useless")
    table.insert(messages, "bottle.")
  elseif str == "juan" or str == "pedro" then
    table.insert(messages, "Juan and Pedro both died far above us.  It's")
    table.insert(messages, "all my fault.")
  elseif str == "escape" or str == "leave" or str == "exit" then
    table.insert(messages, "The German's notes said that the only way")
    table.insert(messages, "to open the exit at the base of the pyramid")
    table.insert(messages, "was with an alien gemstone.")
  elseif str == "alien" or str == "gemstone" then
    table.insert(messages, "This stone is at the bottom of the pyramid's")
    table.insert(messages, "dungeons, supposedly.  We never found it.")
  elseif str == "fault" then
    table.insert(messages, "All I can do is think that I am responsible")
    table.insert(messages, "for their deaths.")
  elseif str == "spirit" or str == "being" or str == "demon" or str == "something" or str == "powerful" then
    table.insert(messages, "I know something appeared, when I opened")
    table.insert(messages, "the bottle.  But I don't know what it was.  I")
    table.insert(messages, "hardly got a glimpse of it.")
  elseif str == "friend" or str == "grandfather" then
    table.insert(messages, "We wondered why the old man never")
    table.insert(messages, "followed the Germans himself.  Now I guess")
    table.insert(messages, "we know.")
  else
    local rand = Game.random(3)
    if rand == 0 then
      table.insert(messages, "I don't understand.")
    elseif rand == 1 then
      table.insert(messages, "You're not making any sense.")
    else
      table.insert(messages, "What did you say?")
    end
  end

  return messages
end
